package fp;

import listFW.*;
import listFW.factory.*;

/**
 * Makes new NEList given a first and rest.
 * @author DXN
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class Cons<T> implements ILambda<IList<T>,Object> {
    private IListFactory<T> _fac;
    public Cons(IListFactory<T> fac) {
        _fac = fac;
    }
    /**
     * Creates an INEList with a given first and rest.
     * @param params[0] the first element of the IList to be created.
     * @param params[1] IList, the rest of the IList to be created.
     * @return INEList
     */
    @SuppressWarnings("unchecked")
    public IList<T> apply(Object... params) {
        return _fac.makeNEList((T)params[0], (IList<T>)params[1]);
    }
}