package listFW.test;

import junit.framework.TestCase;

import fp.*;
import listFW.*;
import listFW.visitor.*;
import listFW.factory.*;

/**
 * Testing appending a list.
 * @author DXN
 */
public class TestAppend extends TestCase {
  final IListFactory<Object> fac = new CompositeListFactory<Object>();
  IList<Object> mt = fac.makeEmptyList();
  IList<Object> ne1 = fac.makeNEList("1", fac.makeNEList("2", fac.makeNEList("3", mt)));
  IList<Object> ne2 = fac.makeNEList("a", fac.makeNEList("b", mt));
  
  // same f as in TestReverse!
  ILambda2<IList<Object>,Object,IList<Object>> f = new ILambda2<IList<Object>,Object,IList<Object>>() {
    public IList<Object> apply(Object arg1, IList<Object> arg2) {
      return fac.makeNEList(arg1, arg2);
    }
  };
  
  // but we fold in a different direction, and use a different initial value
  FoldR<Object,IList<Object>> algo = new FoldR<Object,IList<Object>>(f);

  @SuppressWarnings("unchecked")
  public void testFoldEmpty() {
    assertEquals("Append Empty/Empty list", "()", mt.execute(algo, mt).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testFoldEmptyNE() {
    assertEquals("Append Empty/NE list", "(1, 2, 3)", mt.execute(algo, ne1).toString());
  }

  @SuppressWarnings("unchecked")
  public void testFoldNEEmpty() {
    assertEquals("Append NE/Empty list", "(a, b)", ne2.execute(algo, mt).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testFoldNENE() {
    assertEquals("Append NE/NE list", "(a, b, 1, 2, 3)", ne2.execute(algo, ne1).toString());
    assertEquals("Append NE/NE list", "(1, 2, 3, a, b)", ne1.execute(algo, ne2).toString());
  }

  @SuppressWarnings("unchecked")
  public void testEmpty() {
    assertEquals("Append Empty/Empty list", "()", mt.execute(new Append<Object>(fac), mt).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testEmptyNE() {
    assertEquals("Append Empty/NE list", "(1, 2, 3)", mt.execute(new Append<Object>(fac), ne1).toString());
  }

  @SuppressWarnings("unchecked")
  public void testNEEmpty() {
    assertEquals("Append NE/Empty list", "(a, b)", ne2.execute(new Append<Object>(fac), mt).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testNENE() {
    assertEquals("Append NE/NE list", "(a, b, 1, 2, 3)", ne2.execute(new Append<Object>(fac), ne1).toString());
    assertEquals("Append NE/NE list", "(1, 2, 3, a, b)", ne1.execute(new Append<Object>(fac), ne2).toString());
  }
}