package listFW.test;

import junit.framework.TestCase;

import fp.*;
import listFW.*;
import listFW.visitor.*;
import listFW.factory.*;

/**
 * Testing reversing a list.
 * @author DXN
 */
public class TestReverse extends TestCase {
  final IListFactory<String> fac = new CompositeListFactory<String>();    
  IList<String> mt = fac.makeEmptyList();
  
  // same f as in TestAppend!
  ILambda2<IList<String>,String,IList<String>> f =
      new ILambda2<IList<String>,String,IList<String>>() {
    public IList<String> apply(String arg1, IList<String> arg2) {
      return fac.makeNEList(arg1, arg2);
    }
  };
  
  // but we fold in a different direction, and use a different initial value
  FoldL<String,IList<String>> algo = new FoldL<String,IList<String>>(f);
  
  @SuppressWarnings("unchecked")
  public void testFoldEmpty() {
    assertEquals("Reverse Empty list", "()", mt.execute(algo, mt).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testFoldNonEmpty() {
    IList<String> L = fac.makeNEList("a", mt);
    assertEquals("Reverse (a)", "(a)", L.execute(algo, mt).toString());
    L = fac.makeNEList("b", L);
    assertEquals("Reverse ( b, a)", "(a, b)", L.execute(algo, mt).toString());
    L = fac.makeNEList("c", L);
    assertEquals("Reverse ( c, b, a)", "(a, b, c)", L.execute(algo, mt).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testEmpty() {
    assertEquals("Reverse Empty list", "()", mt.execute(new Reverse<String>(), fac).toString());
  }
  
  @SuppressWarnings("unchecked")
  public void testNonEmpty() {
    IList<String> L = fac.makeNEList("a", mt);
    assertEquals("Reverse (a)", "(a)", L.execute(new Reverse<String>(), fac).toString());
    L = fac.makeNEList("b", L);
    assertEquals("Reverse ( b, a)", "(a, b)", L.execute(new Reverse<String>(), fac).toString());
    L = fac.makeNEList("c", L);
    assertEquals("Reverse ( c, b, a)", "(a, b, c)", L.execute(new Reverse<String>(), fac).toString());
  }

}