package listFW.visitor;

import listFW.*;

/**
 * Append another list, passed as input[0], at the end of this list.
 */
public class Append<T> implements IListAlgo<T,IList<T>,IList<T>> {  
    private IListFactory<T> _fac;
    
    public Append(IListFactory<T> fac) {
        _fac = fac;
    }
    
    /**
     * Returns the input list.
     * @param input input[0] is the list to append.
     */
    public IList<T> emptyCase(IMTList<? extends T> host, IList<T>... input) {
        return input[0];
    }
    
    /**
     * Returns the appended lists.
     * @param input input[0] is the list to append.
     */
    public IList<T> nonEmptyCase(INEList<? extends T> host, IList<T>... input) {
        return _fac.makeNEList(host.getFirst(), 
                               host.getRest().execute(this, input));
    }
}