package listFW.visitor;

import listFW.*;

/**
 * Reverses a list. The first of the varargs (input[0]) needs to be an IListFactory.
 */
public class Reverse<T> implements IListAlgo<T,IList<T>,IListFactory<T>> {
    /**
     * Returns the empty list.
     * @param fac fac[0] is a list factory
     */
    @SuppressWarnings("unchecked")
    public IList<T> emptyCase(IMTList<? extends T> host, IListFactory<T>... fac) {
        return (IList<T>)host;
    }
    
    /**
     * Returns the reversed list.
     * @param fac fac[0] is a list factory
     */
    @SuppressWarnings("unchecked")
    public IList<T> nonEmptyCase(INEList<? extends T> host, final IListFactory<T>... fac) {
        // use a helper to do forward accumulation
        // initial value is the empty list
        return host.execute(new IListAlgo<T,IList<T>,IList<T>>() {
            public IList<T> emptyCase(IMTList<? extends T> host, IList<T>... input) {
                // return the accumulator
                return input[0];
            }
            public IList<T> nonEmptyCase(INEList<? extends T> host, IList<T>... input) {
                // create a new NEList out of the first and the accumulator, then recur
                return host.getRest().execute(this,
                                              fac[0].makeNEList(host.getFirst(), input[0]));        
            }
        }, fac[0].makeEmptyList());
    }
}