package listFW.visitor;

import listFW.*;

/**
 * Reverses a particular kind of list only
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class ReverseList<T> implements IListAlgo<T,IList<T>, IListFactory<T>>  {
    
    public IMTList<T> emptyCase(IMTList<? extends T> host, IListFactory<T> ... fac) {
        return fac[0].makeEmptyList(); 
    }
    @SuppressWarnings("unchecked")
    public INEList<T> nonEmptyCase(INEList<? extends T> host, final IListFactory<T> ... fac) {
        return host.getRest().execute(new IListAlgo<T,INEList<T>, INEList<T>>()  {
            public INEList<T> emptyCase(IMTList<? extends T> h, INEList<T> ... acc) {
                return acc[0];
            }
            public INEList<T> nonEmptyCase(INEList<? extends T> h, INEList<T>... acc) {
                return h.getRest().execute(this, fac[0].makeNEList(h.getFirst(), acc[0]));
            }
        }, fac[0].makeNEList(host.getFirst(), fac[0].makeEmptyList()));
    }
}


