package listFW.visitor;

import listFW.*;
/**
 * Sums a list of Numbers, but only the integer part of the values.
 * A test to see if the methods could be declared to return a subclass 
 * of the paramaterized type.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */ 
public class SumIntValList implements IListAlgo<Number,Number,Object> {
    
    public Integer emptyCase(IMTList<? extends Number> host, Object ... inp) {
        return 0;
    }
    public Integer nonEmptyCase(INEList<? extends Number> host, Object ... inp) {
        return host.getFirst().intValue() + host.getRest().execute(this).intValue();
    }
}
