package genvisitor;

/**
 * A generic visitor to a host of type H.  
 * 
 * @param R The return type
 * @param I The index type used by the host to select a case
 * @param P The vararg parameter type
 * @param H The type of the host this visitor expects to see.
 */
public interface IGenVisitor<R, I, P, H> {
  
  /**
   * The parameterized case statement called by a host's execute method.
   * The host's execute method calls caseAt with an index value 
   * corresponding to that host.
   * @param idx The index supplied by the host
   * @param host The host itself
   * @param inps The vararg input parameters
   */
  public R caseAt(I idx, H host, P... inps);
}