package parser;

import genvisitor.*;

/**
 * Abstract token class.
 */
public abstract class AToken implements IGenVisitorHost<String, AToken> {
  
    /**
     * The _lexeme this token is representing.
     */
    private String _lexeme;

    /**
     * Token constructor.
     *
     * @param lexeme _lexeme this token is representing.
     */
    public AToken(String lexeme) {
        _lexeme = lexeme;
    }


    /**
     * Execute a token visitor.
     *
     * @param algo  visitor to execute
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public abstract <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps);

    /**
     * Return a string representation of the token.
     *
     * @return string representation
     */
    public String toString() {
        return _lexeme;
    }
}

