package parser;
import genvisitor.*;

/**
 * End of file token class.
 */
public class EOFToken extends AToken {


    /**
     * Singleton instance.
     */
    public final static EOFToken Singleton = new EOFToken();

    /**
     * Private singleton constructor.
     */
    private EOFToken() {
        super("EOF");
    }

    /**
     * Execute the eof case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
        return algo.caseAt("EOF", this, inps);
    }
}

