package parser;
import genvisitor.*;

/**
 * Id token class.
 */
public class IdToken extends AToken {


    /**
     * Constructor for a id token.
     *
     * @param lexeme id lexeme
     */
    public IdToken(String lexeme) {
        super(lexeme);
    }

    /**
     * Execute the id case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
        return algo.caseAt("Id", this, inps); 
    }
}

