package com.ridgesoft.robotics;

/**
 * Generic interface to a variable power motor.  Forward and reverse are set
 * correctly depending on whether this interface is for the left or right side
 * motor.
 */
public interface Motor {
  public static final int MAX_FORWARD = 16; 
  public static final int MAX_REVERSE = -16; 
  public static final int STOP = 0;
  
  /**
   * Sets the motor's power. 
   * @power The power level to set, within the bounds set above.  power= STOP will stop the motor. 
   */
  public void setPower(int power); 
  
  /**
   * Turns the motor power off, allowing the motor to coast or stop.  
   */
  public void stop();     
}