
package counter;
import logic.*;

/**
 * @dependency EqualsZero uses
 */
class ZeroState extends ACounterState
 implements ILogicAlgo
{
 /** @SBGen Singleton Variable   */
 public static ZeroState Singleton = new ZeroState();
 private int count;


 /** @SBGen Constructor   */
 private ZeroState()
 {
  }

 /**
  * @param host 
  */
 Counter decrement(Counter host)
 {
  host.setCounterState(new NonZeroState(-1));
  return(host);
 }

 /**
  * @param host 
  */
 Counter increment(Counter host)
 {
  host.setCounterState(new NonZeroState(1));
  return(host);
 }

 /**
  * @param host 
  * @param algo 
  * @param param 
  */
 Object execute(Counter host, ICounterAlgo algo, Object param)
 {
  return(algo.zeroCase(host,param));
 }

 /**
  * @param host 
  */
 int getCount(Counter host)
 {
  return(0);
 }

 /**
  * @param host 
  * @param count 
  */
 void setCount(Counter host, int count)
 {
  this.count = count;
  EqualsZero.Singleton.isTrue(new Integer(count)).execute(this, host);
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object trueCase(ILogical host, Object param)
 {
  return (null); // NYI 
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object falseCase(ILogical host, Object param)
 {
  ((Counter) param).setCounterState(new NonZeroState(count));
  return (null); // NYI
 }
}

