package lrs.visitor;
import lrs.*;
// This visitor returns the minimum value from a list
public class GetMin extends AGetExtrema {
  
  public static GetMin Singleton = new GetMin();
  
  private GetMin()
  {
  }
  
  public Object nullCase(LRStruct host, Object param)
  {
    return(new Integer(Integer.MAX_VALUE));   // The empty list has a valid return object that will always fail a compare.
  }
  
  public Object nonNullCase(LRStruct host, Object param)
  {
    Integer tmp = (Integer) host.getRest().execute(this, param);  // Get the min of the rest of the list
    
    //return the data that passes the compare test.
    if(tmp.intValue() < ((Integer)host.getFirst()).intValue())  return (tmp);
    else return (host.getFirst());
  }
  
}