package lrs.visitor;
import lrs.*;

// This visitor implements a selection sort on a LRS containing
// Integer data.   Always returns the whole list.
public class SelectionSort implements IAlgo
{
  AGetExtrema aGetExtrema; /**
   * @param getExtrema 
   */
  public SelectionSort(AGetExtrema getExtrema)
  {
    aGetExtrema = getExtrema;
  }
  
  
  public Object nullCase(LRStruct host, Object param)
  {
    return host;  // Sort is done!
  }
  
  public Object nonNullCase(LRStruct host, Object param)
  {
    Integer min = (Integer) host.execute( aGetExtrema, param); // Get the min value of the list
    host.execute(RemoveItem.Singleton, min);  // Remove that min value from the list
    host.insertAsFirst(min);  // Insert that min value at the front of the list
    host.getRest().execute(this, param);  // Recurse on the rest of the list
    return host;  // Always return the whole list.
  }
}
