package lrs.visitor;

import lrs.*;
import fp.*;

/**
 * empty case: foldr(empty, f, b) = b;
 * non-empty case: foldr(host, f, b) = f(host, foldr(host.rest, f, b));
 */
public class FoldrLRS implements IAlgo {
    private ILambda _f;
    
    public FoldrLRS(ILambda f) {
        _f = f;
    }
    
    public Object emptyCase(LRStruct host, Object b) {
        return b;
    }
    
    public Object nonEmptyCase(LRStruct host, Object b) {
        return _f.apply(host, host.getRest().execute(this, b));
    }
}