package lrs.visitor.test;

import lrs.*;
import lrs.visitor.*;
import lrs.visitor.fold.*;
import junit.framework.TestCase;


public class Test_FoldAddMach extends TestCase {
  
  private LRStruct makeLRS(Object ... p) {
    LRStruct result = new LRStruct();
    for(int i = p.length-1; i >=0; i--) {
      result.insertFront(p[i]);
    }
    return result;
  }

  public void test_Foldl_AddingMachine() {
    IAlgo foldl = new FoldlLRS(AddingMachine.Singleton);
    LRStruct list = makeLRS();
    LRStruct b = makeLRS(0);
  
    assertEquals("empty list", "(0)", list.execute(foldl, b).toString());
    list = makeLRS(42);             
    b = makeLRS(0);   // b gets mutated
    assertEquals("1-elt list", "(42 0)", list.execute(foldl, b).toString());
    list = makeLRS(3, 4);             
    b = makeLRS(0); // b gets mutated
    assertEquals("2-elt list", "(7 3 0)", list.execute(foldl, b).toString());
    list = makeLRS(3, 4, 5);             
    b = makeLRS(0); // b gets mutated
    assertEquals("3-elt list", "(12 7 3 0)", list.execute(foldl, b).toString());
  }
  
}
