package lrs.visitor.test;

import junit.framework.TestCase;
import lrs.*;
import lrs.visitor.*;
import fp.*;

/**
 * Testing MinLRS visitor.
 * @author DXN
 * @since 09/27/04
 */
public class Test_MinLRS extends TestCase {
    private static IAlgo m = MinLRS.Singleton;
    
    /**
     */
    public void testEmpty() {
        LRStruct lrs = new LRStruct();
        assertEquals("Foldl Min LRS:", lrs, lrs.execute(m, lrs));
    }
    
    /**
     */
    public void testNonEmpty() {
        LRStruct lrs = new LRStruct();        
        lrs.insertFront(5);
        Object minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\n Min LRS is:\n"+ minLRS + '\n');        
        assertEquals(" Min LRS for non-empty tree:", lrs, minLRS);

        lrs.getRest().insertFront(-2);
        minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\n Min LRS is:\n"+ minLRS + '\n');        
        assertEquals("Min LRS for non-empty tree:", lrs.getRest(), minLRS);

        lrs.getRest().insertFront(10);
        minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\n Min LRS is:\n"+ minLRS + '\n');        
        assertEquals("Min LRS for non-empty tree:", lrs.getRest().getRest(), minLRS);

        lrs.getRest().getRest().insertFront(-9);
        minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\nMin LRS is:\n"+ minLRS + '\n');        
        assertEquals("Min LRS for non-empty tree:", lrs.getRest().getRest(), minLRS);    }
}
