package brs.visitor.traverse;
import fp.*;

import brs.*;

/**
 * Returns the minimum of 2 trees.
 * @author DXN
 */
public class Min2Tree implements ILambda {
    public static final Min2Tree Singleton = new Min2Tree();
    private Min2Tree() {
    };
    
    private static IVisitor min = new IVisitor() {
        public Object emptyCase(BiTree host, Object inp) {
            return inp;
        }
        
        public Object nonEmptyCase(BiTree host, Object inp) {
            BiTree temp = (BiTree)inp;
            return (Integer)host.getRootDat() < (Integer)temp.getRootDat()? host: temp;
        }
    };
    
    public Object apply(Object... args) {
        return ((BiTree)args[0]).execute(min, args[1]);
    }
}