package brs.visitor.traverse.test;

import brs.*;
import brs.visitor.*;
import brs.visitor.traverse.*;
import fp.*;


import junit.framework.TestCase;
/**
 */
public class Test_InOrderMin extends TestCase {
    private static IVisitor m = new InOrder1(Min3Tree.Singleton);
    /**
     */
    public void testEmptyCase() {
        BiTree bt = new BiTree();
        assertEquals("In Order MinTree for empty tree:", bt, bt.execute(m, bt));
    }

    /**
     */
    public void testNECase() {
        BiTree bt = new BiTree();        
        bt.insertRoot(5);
        Object minTree = bt.execute(m, bt);
        System.out.println(bt + "\nIn Order Min Tree is:\n"+ minTree + '\n');        
        assertEquals("In Order MinTree for non-empty tree:", bt, minTree);

        bt.getLeftSubTree().insertRoot(-2);
        minTree = bt.execute(m, bt);
        System.out.println(bt + "\nIn Order Min Tree is:\n"+ minTree + '\n');        
        assertEquals("In Order MinTree for non-empty tree:", bt.getLeftSubTree(), minTree);

        bt.getRightSubTree().insertRoot(10);
        minTree = bt.execute(m, bt);
        System.out.println(bt + "\nIn Order Min Tree is:\n"+ minTree + '\n');        
        assertEquals("In Order MinTree for non-empty tree:", bt.getLeftSubTree(), minTree);

        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);
        minTree = bt.execute(m, bt);
        System.out.println(bt + "\nIn Order Min Tree is:\n"+ minTree + '\n');        
        assertEquals("In Order MinTree for non-empty tree:", bt.getRightSubTree().getLeftSubTree(), minTree);
    }
}
