package brs.visitor.traverse.test;

import brs.*;
import brs.visitor.*;
import brs.visitor.traverse.*;
import fp.*;
import listFW.*;

import junit.framework.TestCase;


public class Test_MinTree extends TestCase {
    private static IVisitor m = MinTree.Singleton;
    /**
     */
    public void testEmptyCase() {
        BiTree bt = new BiTree();
        assertEquals("MinTree for empty tree:", bt, bt.execute(m, null));
    }

    /**
     */
    public void testNECase() {
        BiTree bt = new BiTree();        
        bt.insertRoot(5);
        Object minTree = bt.execute(m, null);
        System.out.println(bt + "\nMin Tree is:\n"+ minTree + '\n');        
        assertEquals("MinTree for non-empty tree:", bt, minTree);

        bt.getLeftSubTree().insertRoot(-2);
        minTree = bt.execute(m, null);
        System.out.println(bt + "\nMin Tree is:\n"+ minTree + '\n');        
        assertEquals("MinTree for non-empty tree:", bt.getLeftSubTree(), minTree);

        bt.getRightSubTree().insertRoot(10);
        minTree = bt.execute(m, null);
        System.out.println(bt + "\nMin Tree is:\n"+ minTree + '\n');        
        assertEquals("MinTree for non-empty tree:", bt.getLeftSubTree(), minTree);

        bt.getRightSubTree().getLeftSubTree().insertRoot(-9); 
        minTree = bt.execute(m, null);
        System.out.println(bt + "\nMin Tree is:\n"+ minTree + '\n');        
        assertEquals("MinTree for non-empty tree:", bt.getRightSubTree().getLeftSubTree(), minTree);
    }
}
