package fp;

import listFW.*;
import listFW.factory.*;

/**
 * Makes new NEList given a first and rest.
 * @author DXN
 */
public class Cons implements ILambda {
    private IListFactory _fac;
    public Cons(IListFactory fac) {
        _fac = fac;
    }
    /**
     * Creates an INEList with a given first and rest.
     * @param params[0] the first element of the IList to be created.
     * @param params[1] IList, the rest of the IList to be created.
     * @return INEList
     */
    public Object apply(Object... params) {
        return _fac.makeNEList(params[0], (IList)params[1]);
    }
}