package lrs;

/**
 * Represents the non-empty state of a LStruct.
 * @author Dung X. Nguyen  Copyright 2005 - All rights reserved.
 * @since 02/09/05
 */
class NENode extends ANode {
    private Object _dat;
    private LRStruct _tail;
    
    /**
     * Initializes this NENode to contain dat and a given tail list.
     * @param dat the data object to be stored in this NENode.
     * @param tail the LRStruct tail of this NENode.
     */
    NENode(Object dat, LRStruct tail) {
        _dat = dat;
        _tail = tail;
    }
    
    LRStruct getRest(LRStruct owner) {
        return _tail;
    }
    
    Object getFirst(LRStruct owner) {
        return _dat;
    }
    
    LRStruct setRest(LRStruct owner, LRStruct tail) {
        _tail = tail;
        return owner;
    }
    
    LRStruct setFirst(LRStruct owner, Object first) {
        _dat = first;
        return owner;
    }
    
    /**
     * Inserts a data object at the front of the LRStruct owner.
     * @param owner the LRS referencing this NENode.
     * @param dat the object to be inserted at the front.
     */
    LRStruct insertFront(LRStruct owner, Object dat) {
        return owner.setHead(new NENode(dat, new LRStruct(this)));
        /* Details:
         // LRStruct coOwner = new LRStruct (this);
         // NENode newNode = new NENode (dat, coOwner);
         // owner.setHead (newNode);
         // "old" style: owner._head = newNode - cannot be done here.
         */
    }
    
    Object removeFront(LRStruct owner) {
        owner.setHead(_tail.getHead()); // owner._head = _tail._head
        return _dat;
    }
    
    /**
     * Calls the visitor's non-empty case.
     */
    Object execute(LRStruct owner, IAlgo algo, Object... input)  {
        return algo.nonEmptyCase(owner, input);
    }
}

