import nx_utils as util

# Example graphs from class notes
sampleGraph1 = {1:[2,3,4], 2:[1,3,5], 3:[1,2], 4:[1,7,9], 5:[2,9], 6:[9], 7:[4], 8:[9], 9:[5,8,6,4]}
sampleGraph2 = {1:[2,3,4], 2:[1,3,5], 3:[1,2], 4:[1,7,9], 5:[2,9], 6:[9], 7:[4], 8:[9], 9:[5,8,6,4], 10:[11, 12], 11:[10], 12:[10]}

# util.plot_graph(sampleGraph1, "SampleGraph1")
# util.plot_graph(sampleGraph2, "SampleGraph2")

"""Pseudo-code for looping type BFS:

source node is initial frontier

is frontier empty?  If yes, there is no path to target.
initialize new frontier
loop through frontier
    is node the target?  If yes, then done.
    add node to visited
    add neighbors to new frontier if neither visited or in current frontier
recurse with new frontier    

"""

def bfs(graph,source,target):
    """Returns the target node, if it is connected to the source node in the dictionary-type graph; 
    otherwise returns None.
    """

    # A local set to store which nodes have been visited by def_help().
    # This needs to be initialized before each call to def_help().
    visited = set()

    def bfs_help(graph,frontier,target):
        """ Helper function that returns the target node, if it is connected in the graph to a 
        source node fron the frontier list; otherwise returns None.  Utilizes the 
        visited set in its closure. 
        """

        if frontier == []:
            print "Frontier is empty!  No path found to ", target
            return None
        print "Current frontier is ", frontier
        nextFrontier = []
        for node in frontier:
            if node in visited:
                # Already been here.  Don't try again.
                print "Been here already: ", node
            else:
                visited.add(node)
                if node == target:
                    # Found it!  We're done.
                    print "Found target = ", target
                    return target            
                else:
                    for nextNode in graph[node]:
                        if nextNode in visited:
                            # Already been here.  Don't try again.
                            print "Been here already: ", nextNode
                        elif nextNode in frontier:
                            # About to go here so ignore too.  
                            print "About to go to ", nextNode, ", thus ignoring."
                        else:
                            # Unencountered node, so add to next frontier
                            nextFrontier.append(nextNode)
        print "Target not found in ", frontier, " recursing to ", nextFrontier
        return bfs_help(graph, nextFrontier, target)
                
    return bfs_help(graph, [source], target)

"""Pseudo-code for non-looping type BFS:

source node is initial frontier ("sources")

Is frontier empty?  If so, there is no path to target.
Is the first node in the frontier in visited?  If yes, recurse to the rest of the frontier, without the first node.
Add first node to visited
Is first node in frontier the target?  If yes, then done.
Otherwise, add children to end of frontier  (for DFS, this is "add to children to FRONT of frontier")
Recurse to the rest of the frontier, without the first node.

"""
    
def bfs2(graph,source,target):
    """Returns the target node, if it is connected to the source node in the dictionary-type graph; 
    otherwise returns None.
    """
    # A local set to store which nodes have been visited by def_help().
    # This needs to be initialized before each call to def_help().
    visited = set()

    def bfs_help(graph,sources,target):
        """ Helper function that returns the target node, if it is connected to one 
        of the given source nodes in the graph; otherwise returns None.
        Utilizes the visited set in its closure.
        Tail-recursive algorithm with no loops and fewer conditional checks.
        """
        
        print "Searching nodes: ", sources
        if sources == []:
            # base case.  Done.  Looked everywhere, so no path to target
            print "Can't find it!"
            return None
            
        print "We're at node",sources[0]            
        if sources[0] in visited:
            # Already been here.  Try nextNodes source
            print "Been here already: ", sources[0]
            return bfs_help(graph, sources[1:], target)  # recurse.  Note that result is not further processed (tail recursive call)

        else:
            # Remember that we've come here.
            visited.add(sources[0])

            if sources[0] == target:
                # Found it!  We're done.
                print "Found target = ", target
                return target

            else:
                # Keep looking from where we're at.
                nextNodes = sources[1:]+graph[sources[0]]   # append the neigbbors onto the rest of the source nodes
                return bfs_help(graph, nextNodes, target)   # recurse.  Note that result is not further processed (tail recursive call)
                
    return bfs_help(graph, [source], target)


def bfsNX(nxGraph,source,target):
    """Returns the target node, if it is connected to the source node in the networkx-type graph; 
    otherwise returns None.   Utlizes the node attribute "visited" to mark the nodes.  The 
    visited attribute is cleared in the whole graph before the algorithm is run.
    """

    
    # clear the visited node attribute
    for n in nxGraph.nodes():
        nxGraph.node[n]["visited"] = False
        
    def bfs_help(nxGraph,sources,target):
        """ Helper function that returns the target node, if it is connected to 
        one of the given source nodes in the nxGraph; otherwise returns None.
        """
        
        print "Searching nodes: ", sources
        if sources == []:
            # base case.  Done.  Looked everywhere, so no path to target
            print "Can't find it!"
            return None
            
        print "We're at node",sources[0]            
        if nxGraph.node[sources[0]]["visited"]:    # Check if the node is marked.
            # Already been here.  Try nextNodes source
            print "Been here already: ", sources[0]
            return bfs_help(nxGraph, sources[1:], target)  # recurse. Note that result is not further processed (tail recursive call)

        else:
            # Remember that we've come here.
            nxGraph.node[sources[0]]["visited"] = True   # mark the node

            if sources[0] == target:
                # Found it!  We're done.
                print "Found target = ", target
                return target

            else:
                # Keep looking from where we're at.
                nextNodes = sources[1:]+nxGraph.neighbors(sources[0])  # append the neigbbors onto the rest of the source nodes
                return bfs_help(nxGraph, nextNodes, target)   # recurse. Note that result is not further processed (tail recursive call)
                
    return bfs_help(nxGraph, [source], target)
    