import nx_utils as util

# Example graphs from class notes
sampleGraph1 = {1:[2,3,4], 2:[1,3,5], 3:[1,2], 4:[1,7,9], 5:[2,9], 6:[9], 7:[4], 8:[9], 9:[5,8,6,4]}
sampleGraph2 = {1:[2,3,4], 2:[1,3,5], 3:[1,2], 4:[1,7,9], 5:[2,9], 6:[9], 7:[4], 8:[9], 9:[5,8,6,4], 10:[11, 12], 11:[10], 12:[10]}

# util.plot_graph(sampleGraph1, "SampleGraph1")
# util.plot_graph(sampleGraph2, "SampleGraph2")


def graphSearchFn(graph,source,target, fn):
    """Returns the target node, if it is connected to the source node in the dictionary-type graph; 
    otherwise returns None.  Uses the fn(sources[1:], graph[sources[0]]) to determine 
    how the neighbors of sources[0] are added to the frontier ("sources").
    """
    # A local set to store which nodes have been visited by def_help().
    # This needs to be initialized before each call to def_help().
    visited = set()

    def helper(graph,sources,target):
        """ Helper function that returns the target node, if it is connected to one 
        of the given source nodes in the graph; otherwise returns None.
        Utilizes the visited set in its closure.
        Tail-recursive algorithm with no loops and fewer conditional checks.
        """
        
        print "Searching nodes: ", sources
        if sources == []:
            # base case.  Done.  Looked everywhere, so no path to target
            print "Can't find it!"
            return None
            
        print "We're at node",sources[0]            
        if sources[0] in visited:
            # Already been here.  Try nextNodes source
            print "Been here already: ", sources[0]
            return helper(graph, sources[1:], target)  # recurse.  Note that result is not further processed (tail recursive call)

        else:
            # Remember that we've come here.
            visited.add(sources[0])

            if sources[0] == target:
                # Found it!  We're done.
                print "Found target = ", target
                return target

            else:
                # Keep looking from where we're at.
                nextNodes = fn(sources[1:], graph[sources[0]])   # append the neigbbors onto the rest of the source nodes
                return helper(graph, nextNodes, target)   # recurse.  Note that result is not further processed (tail recursive call)
                
    return helper(graph, [source], target)

    
def append(l1, l2):
    """ l1 and l2 are lists.  Returns l2 appended to l1.
    """
    return l1 + l2
    
def prepend(l1, l2):
    """ l1 and l2 are lists.  Returns l2 prepended to l1.
    """
    return l2+ l1  
