import nx_utils as util

# Example graphs from class notes
sampleGraph1 = {1:[2,3,4], 2:[1,3,5], 3:[1,2], 4:[1,7,9], 5:[2,9], 6:[9], 7:[4], 8:[9], 9:[5,8,6,4]}
sampleGraph2 = {1:[2,3,4], 2:[1,3,5], 3:[1,2], 4:[1,7,9], 5:[2,9], 6:[9], 7:[4], 8:[9], 9:[5,8,6,4], 10:[11, 12], 11:[10], 12:[10]}

# util.plot_graph(sampleGraph1, "SampleGraph1")
# util.plot_graph(sampleGraph2, "SampleGraph2")

class RAC:
    """ Restricted Access Container.
    A container with an internal data storage that allows you to add items to that data store
    in an encapsulated manner.
    Retrieval of data items is not defined at this level.
    """
    def __init__(self):
        """ Constructor for the class.   Initializes the internal data store.
        """
        self._data = []

    def put(self, x):
        """ Add the given data item, x, to the internal data store.
        For convenience, returns the RAC itself.
        """
        self._data.append(x)
        return self
    
    def putList(self, aList):
        """ Convenience method to add a list if items to the internal data store.  
        Items are added in order starting from the front of the given list.
        For convenience, returns the RAC itself.
        """
        for x in aList:
            self.put(x)
        return self
    
    def isEmpty(self):
        """ REturns true if the internal data store is empty.  Returns false otherwise.
        """
        return 0 == len(self._data)
    
    def __str__(self):
        """ Returns the string representation of the internal data store, in order from oldest to the newest elements.
        """
        return str(self._data)
        
class Stack(RAC):
    """ Stack subclass of RAC where the data is retrieved in a 
    First In/Last Out (FILO) order.
    Inherits put(), putList(), isEmpty() and __str__() from RAC.
    """
   
    def __init__(self):
        """ Class constructor.  Simply calls the superclass constructor.
        """
        RAC.__init__(self)
        
    
    def get(self):
        """ Returns that latest element that was put into the Stack.
        Throws an exception if the Stack is empty.
        """
        return self._data.pop()
        

    
class Queue(RAC):
    """ Queue subclass of RAC where the data is retrieved in a 
    First In/First Out (FIFO) order.
    Inherits put(), putList(), isEmpty() and __str__() from RAC.
    """
   
    def __init__(self):
        """ Class constructor.  Simply calls the superclass constructor.
        """
        RAC.__init__(self)
        
    def get(self):
        """ Returns the oldest element currently in the Queue.
        Throws an exception if the Queue is empty.
        """
        return self._data.pop(0)
    
     
    
def graphSearchRAC(graph,rac,target):
    """Returns the target node, if it is connected to a source node in the supplied RAC in the dictionary-type graph; 
    otherwise returns None.
    """
    # A local set to store which nodes have been visited by def_help().
    # This needs to be initialized before each call to def_help().
    visited = set()

    def helper(graph,sources,target):
        """ Helper function that returns the target node, if it is connected to one 
        of the given source nodes in the graph; otherwise returns None.
        Utilizes the visited set in its closure.
        Tail-recursive algorithm with no loops and fewer conditional checks.
        """
        
        print "Searching nodes: ", sources

        if rac.isEmpty():
            # base case.  Done.  Looked everywhere, so no path to target
            print "Can't find it!"
            return None
            
        source = rac.get()
        print "We're at node",source            
        if source in visited:
            # Already been here.  Try nextNodes source
            print "Been here already: ", source
            return helper(graph, rac, target)  # recurse.  Note that result is not further processed (tail recursive call)

        else:
            # Remember that we've come here.
            visited.add(source)

            if source == target:
                # Found it!  We're done.
                print "Found target = ", target
                return target

            else:
                # Keep looking from where we're at.
                rac.putList(graph[source])   # append the neighbors onto the rest of the source nodes
                return helper(graph, rac, target)   # recurse.  Note that result is not further processed (tail recursive call)
                
    return helper(graph, rac, target)

