package rac;

import listFW.*;

/**
 * Defines the interface for a restricted access container.
 */
public interface IRAContainer {
    /**
     * Empty the container.
     * NOTE: This implies a state change.
     * This behavior can be achieved by repeatedly removing elements from this IRAContainer.
     * It is specified here as a convenience to the client.
     */
    public abstract void clear();

    /**
     * Return TRUE if the container is empty; otherwise, return
     * FALSE. 
     */
    public abstract boolean isEmpty();

    /**
     * Return TRUE if the container is full; otherwise, return
     * FALSE. 
     */
    public abstract boolean isFull();

    /**
     * Return an immutable list of all elements in the container.
     * @param fact for manufacturing an IList.
     */
    public abstract IList elements(IListFactory fact);

    /**
     * Remove the next item from the container and return it.
     * NOTE: This implies a state change.
     * @throw an Exception if this IRAContainer is empty.
     */
    public abstract Object get();

    /**
     * Add an item to the container.
     * NOTE: This implies a state change.
     * @param input the Object to be added to this IRAContainer.
     * @throw an Exception if this IRAContainer is full.
     */
    public abstract void put(Object input);
    
    /**
     * Return the next element in this IRAContainer withour removing it.
     * @throw an Exception if this IRAContainer is empty.
     */
    public abstract Object peek();
}
