package util.test;
import util.*;

import junit.framework.TestCase;


public class Test_SmartArray extends TestCase {
  
  public void test_toString1() {
    assertEquals("Empty string: ","{}", SmartArray.toString(new Object[]{}));
    assertEquals("1 Element string: ","{a}", SmartArray.toString(new Object[]{"a"}));
    assertEquals("2 Element string: ","{a, b}", SmartArray.toString(new Object[]{"a", "b"}));
    assertEquals("3 Element string: ","{a, b, c}", SmartArray.toString(new Object[]{"a", "b", "c"}));
  }
  
  public void test_toString2() {
    assertEquals("Empty string: ","[{}, 0]", SmartArray.toSmartArray(new Object[]{}).toString());
    assertEquals("1 Element string: ","[{a}, 1]", SmartArray.toSmartArray(new Object[]{"a"}).toString());
    assertEquals("2 Element string: ","[{a, b}, 2]", SmartArray.toSmartArray(new Object[]{"a", "b"}).toString());
    assertEquals("3 Element string: ","[{a, b, c}, 3]", SmartArray.toSmartArray(new Object[]{"a", "b", "c"}).toString());
  }
  
  public void test_add() {
    SmartArray sa = new SmartArray();
    assertEquals("Empty: ", "[{null}, 0]", sa.toString());
    sa.add("a");
    assertEquals("1 element: ", "[{a}, 1]", sa.toString());
    sa.add("b");
    assertEquals("2 elements: ", "[{a, b}, 2]", sa.toString());
    sa.add("c");
    assertEquals("3 elements: ", "[{a, b, c, null}, 3]", sa.toString());
    sa.add("d");
    assertEquals("4 elements: ", "[{a, b, c, d}, 4]", sa.toString());
    sa.add("e");
    assertEquals("5 elements: ", "[{a, b, c, d, e, null, null, null}, 5]", sa.toString());
  }
  public void test_remove() {
    SmartArray sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c", "d", "e"});
    sa.remove(0);
    assertEquals("remove first element: ", "[{b, c, d, e, e}, 4]", sa.toString());
    sa.remove(1);
    assertEquals("remove #1 element: ", "[{b, d, e, e, e}, 3]", sa.toString());
    sa.remove(2);
    assertEquals("remove last element: ", "[{b, d, e, e, e}, 2]", sa.toString());
    sa.remove(0);
    assertEquals("remove first element: ", "[{d, d, e, e, e}, 1]", sa.toString());
    sa.remove(0);
    assertEquals("remove only element: ", "[{d, d, e, e, e}, 0]", sa.toString());
  }
  
  public void test_toArray() {
    SmartArray sa = SmartArray.toSmartArray(new Object[]{"a", "b"});
    Object[] array = sa.toArray();
    assertTrue("2 elements: ", isEqual(new Object[]{"a", "b"}, array));
    sa.remove(0);
    array = sa.toArray();
    assertTrue("1 element: ", isEqual(new Object[]{"b"}, array));
    sa.remove(0);
    array = sa.toArray();
    assertTrue("Zero elements: ", isEqual(new Object[]{}, array));
  }
  
  public void test_remDup() {
    SmartArray sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c", "d", "e"});
    SmartArray result = sa.remDup();
    assertTrue("No dups, orig array: ",  isEqual(new Object[]{"a", "b", "c", "d", "e"}, sa.toArray()));
    assertTrue("No dups, result array: ",  isEqual(new Object[]{}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "a", "d", "e"});
    result = sa.remDup();
    assertTrue("1 dups, orig array: ",  isEqual(new Object[]{"a", "b", "d", "e"}, sa.toArray()));
    assertTrue("1 dups, result array: ",  isEqual(new Object[]{"a"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "a", "a", "e"});
    result = sa.remDup();
    assertTrue("2 dups, orig array: ",  isEqual(new Object[]{"a", "b", "e"}, sa.toArray()));
    assertTrue("2 dups, result array: ",  isEqual(new Object[]{"a"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "a", "a", "b"});
    result = sa.remDup();
    assertTrue("2 sets of dups, orig array: ",  isEqual(new Object[]{"a", "b"}, sa.toArray()));
    assertTrue("2 sets of dups, result array: ",  isEqual(new Object[]{"a", "b"}, result.toArray()));
  }

/*  UNCOMMENT IF DOING EXTRA CREDIT 
  public void test_remDupBetter() {
    SmartArray sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c", "d", "e"});
    SmartArray result = sa.remDupBetter();
    assertTrue("No dups, orig array: ",  isEqual(new Object[]{"a", "b", "c", "d", "e"}, sa.toArray()));
    assertTrue("No dups, result array: ",  isEqual(new Object[]{}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "a", "d", "e"});
    result = sa.remDupBetter();
    assertTrue("1 dups, orig array: ",  isEqual(new Object[]{"a", "b", "d", "e"}, sa.toArray()));
    assertTrue("1 dups, result array: ",  isEqual(new Object[]{"a"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "a", "a", "e"});
    result = sa.remDupBetter();
    assertTrue("2 dups, orig array: ",  isEqual(new Object[]{"a", "b", "e"}, sa.toArray()));
    assertTrue("2 dups, result array: ",  isEqual(new Object[]{"a"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "a", "a", "b"});
    result = sa.remDupBetter();
    assertTrue("2 sets of dups, orig array: ",  isEqual(new Object[]{"a", "b"}, sa.toArray()));
    assertTrue("2 sets of dups, result array: ",  isEqual(new Object[]{"a", "b"}, result.toArray()));
  }
*/
  public void test_unzip() {
    SmartArray sa = SmartArray.toSmartArray(new Object[]{});
    SmartArray result = sa.unzip();
    assertTrue("empty array, original: ",  isEqual(new Object[]{}, sa.toArray()));
    assertTrue("empty array, result: ",  isEqual(new Object[]{}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a"});
    result = sa.unzip();
    assertTrue("1 element array, original: ",  isEqual(new Object[]{"a"}, sa.toArray()));
    assertTrue("1 element array, result: ",  isEqual(new Object[]{}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b"});
    result = sa.unzip();
    assertTrue("2 element array, original: ",  isEqual(new Object[]{"a"}, sa.toArray()));
    assertTrue("2 element array, result: ",  isEqual(new Object[]{"b"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c"});
    result = sa.unzip();
    assertTrue("3 element array, original: ",  isEqual(new Object[]{"a", "c"}, sa.toArray()));
    assertTrue("3 element array, result: ",  isEqual(new Object[]{"b"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c", "d"});
    result = sa.unzip();
    assertTrue("4 element array, original: ",  isEqual(new Object[]{"a", "c"}, sa.toArray()));
    assertTrue("4 element array, result: ",  isEqual(new Object[]{"b", "d"}, result.toArray()));
  }

  public void test_unzipBetter() {
    SmartArray sa = SmartArray.toSmartArray(new Object[]{});
    SmartArray result = sa.unzipBetter();
    assertTrue("empty array, original: ",  isEqual(new Object[]{}, sa.toArray()));
    assertTrue("empty array, result: ",  isEqual(new Object[]{}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a"});
    result = sa.unzipBetter();
    assertTrue("1 element array, original: ",  isEqual(new Object[]{"a"}, sa.toArray()));
    assertTrue("1 element array, result: ",  isEqual(new Object[]{}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b"});
    result = sa.unzipBetter();
    assertTrue("2 element array, original: ",  isEqual(new Object[]{"a"}, sa.toArray()));
    assertTrue("2 element array, result: ",  isEqual(new Object[]{"b"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c"});
    result = sa.unzipBetter();
    assertTrue("3 element array, original: ",  isEqual(new Object[]{"a", "c"}, sa.toArray()));
    assertTrue("3 element array, result: ",  isEqual(new Object[]{"b"}, result.toArray()));
    sa = SmartArray.toSmartArray(new Object[]{"a", "b", "c", "d"});
    result = sa.unzipBetter();
    assertTrue("4 element array, original: ",  isEqual(new Object[]{"a", "c"}, sa.toArray()));
    assertTrue("4 element array, result: ",  isEqual(new Object[]{"b", "d"}, result.toArray()));
  }
  
  public void test_zip() {
    SmartArray sa1 = SmartArray.toSmartArray(new Object[]{});
    SmartArray sa2 = SmartArray.toSmartArray(new Object[]{});
    sa1.zip(sa2);
    assertTrue("empty + empty: ",  isEqual(new Object[]{}, sa1.toArray()));
    
    sa1 = SmartArray.toSmartArray(new Object[]{"a"});
    sa2 = SmartArray.toSmartArray(new Object[]{});
    sa1.zip(sa2);
    assertTrue("1 + empty : ",  isEqual(new Object[]{"a"}, sa1.toArray()));
    
    sa1 = SmartArray.toSmartArray(new Object[]{});
    sa2 = SmartArray.toSmartArray(new Object[]{"x"});
    sa1.zip(sa2);
    assertTrue("empty + 1: ",  isEqual(new Object[]{"x"}, sa1.toArray()));
    
    sa1 = SmartArray.toSmartArray(new Object[]{"a"});
    sa2 = SmartArray.toSmartArray(new Object[]{"x"});
    sa1.zip(sa2);
    assertTrue("1 + 1: ",  isEqual(new Object[]{"a", "x"}, sa1.toArray()));
    
    sa1 = SmartArray.toSmartArray(new Object[]{"a", "b"});
    sa2 = SmartArray.toSmartArray(new Object[]{"x"});
    sa1.zip(sa2);
    assertTrue("2 + 1: ",  isEqual(new Object[]{"a", "x", "b"}, sa1.toArray()));
    
    sa1 = SmartArray.toSmartArray(new Object[]{"a"});
    sa2 = SmartArray.toSmartArray(new Object[]{"x", "y"});
    sa1.zip(sa2);
    assertTrue("1 + 2: ",  isEqual(new Object[]{"a", "x", "y"}, sa1.toArray()));
    
    sa1 = SmartArray.toSmartArray(new Object[]{"a", "b"});
    sa2 = SmartArray.toSmartArray(new Object[]{"x", "y"});
    sa1.zip(sa2);
    assertTrue("2 + 2: ",  isEqual(new Object[]{"a", "x", "b", "y"}, sa1.toArray()));
  }
  
  /**
   * utility method that returns true if the arrays are equal. 
   * Replace the body of this method if you write you own ArrayUtil.equals() 
   */
  private boolean isEqual(Object[] x, Object[] y) {
    return java.util.Arrays.equals(x, y);
  }
  

}
