package brs.visitor;
import brs.*;

import java.util.*;  // uses Comparable


/**
 * Write a BiTree visitor, called CountGreaterThan, for execution on a binary search tree (BST) 
 * that counts all objects greater than a given key.  
 * The key is passed as a parameter to the visitor.  
 * An Integer representing the total number of data objects in the host tree that are greater than
 * the given input key is returned.
 * Assume the host tree contains Comparable objects.
 * Finally, to receive full credit, your visitor must visit the fewest possible nodes.
 * @author DXN
 */
public class CountGreaterThan implements IVisitor {
    
    public static final CountGreaterThan Singleton = new CountGreaterThan();
    private CountGreaterThan() {
    }
    
    public Object emptyCase(BiTree host, Object key) {
      //TODO
        return new Integer(0);
    }
    
    public Object nonEmptyCase(BiTree host, Object key) {
      //TODO
        if (((Comparable)key).compareTo(host.getRootDat()) < 0) { // key < root
            return add(host.getLeftSubTree().execute(this, key), 
                addOne(host.getRightSubTree().execute(CountNodes.Singleton, null)));
        }
        else { // root <= key
            return host.getRightSubTree().execute(this, key);
        }
    }
    
    /**
     * Utility method to add one to an Object and return an Integer
     * @param i An Integer object
     * @return An Integer object whose value is i+1.
     */
    private Integer addOne(Object i) {
        return new Integer(1 + ((Integer)i).intValue());
    }
    
    /**
     * Utility method to add two Integers and return and Integer
     * @param i An Integer object
     * @param j An Integer object
     * @return An Integer object whose value is i+j.
     */
    private Integer add(Object i, Object j) {
        return new Integer(((Integer)i).intValue() + ((Integer)j).intValue());
    }
}