package brs.visitor;
import brs.*;

/**
 * Returns the subtree of the host with the min value in the root
 * if the tree is not empty, otherwise returns the host itself.
 */
public class MinTreeFinder implements IVisitor {
    public final static MinTreeFinder Singleton = new MinTreeFinder ();

    private MinTreeFinder() {
    }

    /**
    * The host tree is empty: the tree containing the min is the host itself.
    * @param host satisfies the binary search tree property.
    * @param input == null, not used.
    * @return host
    */
    public Object emptyCase (BiTree host, Object input) {
        return host;
    }

    /**
    * Asks the left subtree of the host to help find the min.
    * Use anonymous class as helper.
    * @param host satisfies the binary search tree property.
    * @param input not used.
    * @return subtree with minimum root.
    */
    public Object nonEmptyCase (BiTree host, Object input) {
        return host.getLeftSubTree().execute(new IVisitor () {
            /**
             * @param hp a Bitree, the parent of h.
             */
            public Object emptyCase (BiTree h, Object hp) {
               return hp;
            }

            /**
             * @param hp a Bitree, the parent of h.
             */
            public Object nonEmptyCase (BiTree h, Object hp) {
               return h.getLeftSubTree ().execute (this, h);
            }
        }, host);
    }
}

