package Sorter.test;
import Sorter.*;
import java.util.Arrays;

import junit.framework.TestCase;

public class Test_SinkSorter extends TestCase {
  
  AOrder aOrder = new AOrder() {
      public boolean lt(Object x, Object y)
      {
        return (((Integer)x).intValue()) < (((Integer)y).intValue());
      }
      
      public boolean eq(Object x, Object y)
      {
        return (((Integer)x).intValue()) == (((Integer)y).intValue());
      }
    };
  
  ASorter sorter = new SinkSorter(aOrder);
  
  public void test_SinkSort() {
    Object[] input = {new Integer(42)};
    Object[] result ={new Integer(42)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("1 element array:", Arrays.equals(result, input));

    input = new Object[]{new Integer(1),  new Integer(2)};
    result = new Object[]{new Integer(1),  new Integer(2)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("2 element array:", Arrays.equals(result, input));

    input = new Object[]{new Integer(2),  new Integer(1)};
    result = new Object[]{new Integer(1),  new Integer(2)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("2 element array:", Arrays.equals(result, input));

    input = new Object[]{new Integer(2),  new Integer(1), new Integer(3)};
    result = new Object[]{new Integer(1),  new Integer(2), new Integer(3)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("3 element array:", Arrays.equals(result, input));

    input = new Object[]{new Integer(3),  new Integer(1), new Integer(2)};
    result = new Object[]{new Integer(1),  new Integer(2), new Integer(3)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("3 element array:", Arrays.equals(result, input));

    input = new Object[]{new Integer(2),  new Integer(3), new Integer(1)};
    result = new Object[]{new Integer(1),  new Integer(2), new Integer(3)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("3 element array:", Arrays.equals(result, input));

    input = new Object[]{new Integer(3),  new Integer(2), new Integer(1)};
    result = new Object[]{new Integer(1),  new Integer(2), new Integer(3)};
    sorter.sort(input, 0, input.length-1);
    assertTrue("3 element array:", Arrays.equals(result, input));
  }
  
}
