package brs.test;
import brs.*;
import brs.visitor.*;
import util.*;

import junit.framework.TestCase;

public class Test_BRS2Array extends TestCase {
  
  private IVisitor _algo = BRS2Array.Singleton; 

  public void test_isEqualBRS() {
    Object[] x = {new Integer(1), new Integer(2)};
    Object[] y = {new Integer(1), new Integer(2)};
    Object[] z = {new Integer(1), new Integer(3)};
    assertTrue("Array equality test: ", isEqual(new Object[0],new Object[0]));
    assertTrue("Array equality test: ", ! isEqual(new Object[0],x));
    assertTrue("Array equality test: ", ! isEqual(x, new Object[0]));
    assertTrue("Array equality test: ", ! isEqual(new Object[1], new Object[0]));
    assertTrue("Array equality test: ", isEqual(x, y));
    assertTrue("Array equality test: ", ! isEqual(x, z));
  }
  
  public void test_emptyBRS() {
    BiTree brs = new BiTree();
    Object[] result = (Object[])brs.execute(_algo,null);
    Object[] answer = {};
    assertTrue("Empty test: ", isEqual(answer, result));
  }
  
  public void test_OneEltBRS() {
    BiTree brs = makeOneEltBRS("a");
    Object[] result = (Object[])brs.execute(_algo,null);
    Object[] answer = {"a"};
    assertTrue("One element test: ", isEqual(answer, result));
  }

  
  public void test_twoEltBRS() {
    BiTree brs = makeOneEltBRS("a");
    brs.setLeftSubTree(makeOneEltBRS("b"));
    Object[] result = (Object[])brs.execute(_algo,null);
    Object[] answer = {"a", "b", null};
    assertTrue("Two element test: ", isEqual(answer, result));

    brs = makeOneEltBRS("a");
    brs.setRightSubTree(makeOneEltBRS("b"));
    result = (Object[])brs.execute(_algo,null);
    answer = new Object[]{"a", null, "b"};
    assertTrue("Two element test: ", isEqual(answer, result));
  }

  public void test_threeEltBRS() {
    BiTree brs = makeOneEltBRS("a");
    brs.setLeftSubTree(makeOneEltBRS("b"));
    brs.setRightSubTree(makeOneEltBRS("c"));
    Object[] result = (Object[])brs.execute(_algo,null);
    Object[] answer = {"a", "b", "c"};
    assertTrue("Three element test: ", isEqual(answer, result));
    
    brs = makeOneEltBRS("a");
    brs.setLeftSubTree(makeOneEltBRS("b"));
    brs.getLeftSubTree().setLeftSubTree(makeOneEltBRS("c"));
    result = (Object[])brs.execute(_algo,null);
    answer = new Object[]{"a","b", null, "c", null, null, null};
    assertTrue("Three element test: ", isEqual(answer, result));

    brs = makeOneEltBRS("a");
    brs.setLeftSubTree(makeOneEltBRS("b"));
    brs.getLeftSubTree().setRightSubTree(makeOneEltBRS("c"));
    result = (Object[])brs.execute(_algo,null);
    answer = new Object[]{"a","b", null, null, "c", null, null};
    assertTrue("Three element test: ", isEqual(answer, result));
  
    brs = makeOneEltBRS("a");
    brs.setRightSubTree(makeOneEltBRS("b"));
    brs.getRightSubTree().setLeftSubTree(makeOneEltBRS("c"));
    result = (Object[])brs.execute(_algo,null);
    answer = new Object[]{"a",null, "b", null, null, "c", null};
    assertTrue("Three element test: ", isEqual(answer, result));

    brs = makeOneEltBRS("a");
    brs.setRightSubTree(makeOneEltBRS("b"));
    brs.getRightSubTree().setRightSubTree(makeOneEltBRS("c"));
    result = (Object[])brs.execute(_algo,null);
    answer = new Object[]{"a",null, "b", null, null, null, "c"};
    assertTrue("Three element test: ", isEqual(answer, result));
  }
  
  
  private BiTree makeOneEltBRS(Object x) {
    BiTree brs = new BiTree();
    brs.insertRoot(x);
    return brs;
  }
  
  
  /**
   * Utility method to test if two arrays are equal.
   * @param x An array of Objects.   May be empty.  May contain null elements.
   * @param y An array of Objects.   May be empty.  May contain null elements.
   * @return true if the arrays are equal. false otherwise.
   */
  private boolean isEqual(Object[] x, Object[] y) {
    return java.util.Arrays.equals(x,y);  // Comment this line out if you did the extra credit.
    //return ArrayUtil.equals(x,y);    // Uncomment this line if you did the extra credit.  
  }
}
