package brs.visitor;
import brs.*;


public class BRS2Array implements IVisitor {
  
  public static final BRS2Array Singleton = new BRS2Array();
  private BRS2Array() {}

  public Object emptyCase(BiTree host, Object inp){
    //TODO
    return new Object[0];
  }
  
  
  public Object nonEmptyCase(BiTree host, Object inp){
    //TODO
    final Object[] result = new Object[(int)Math.pow(2, ((Integer)host.execute(GetHeight.Singleton, null)).intValue())-1];
    
    host.execute(new IVisitor() {
      public Object emptyCase(BiTree host2, Object idx){
        return null;
      }
      public Object nonEmptyCase(BiTree host2, Object idx){
        result[((Integer)idx).intValue()] = host2.getRootDat();
        host2.getLeftSubTree().execute(this, times2plus1(idx));
        host2.getRightSubTree().execute(this, times2plus2(idx));
        return null;
      }
    }, new Integer(0));
    return result;
  }
  
  /**
   * utility method to calculate 2*i + 1 
   * given i as an Object and returning an Integer
   * @param i An Integer object
   * @return An Integer object whose value is 2*i+1
   */
  private Integer times2plus1(Object i) {
    return new Integer( 2*intValue(i)+1);
  }

  /**
   * utility method to calculate 2*i + 2 
   * given i as an Object and returning an Integer
   * @param i An Integer object
   * @return An Integer object whose value is 2*i+2
   */
  private Integer times2plus2(Object i) {
    return new Integer( 2*intValue(i)+2);
  }
  
  /**
   * Utility method to get the int value from an Object.
   * @param i An Integer object.
   * @return The int value of i.
   */
  private int intValue(Object i) {
    return ((Integer)i).intValue();
  }
}

