package frog;

import java.awt.*;

/**
 * Interface that represents a frog.
 */
public interface IFrog {
  /**
   * Accessor method for the position of the frog.
   * @return The position Point of the frog
   */
  public abstract Point getPos();
  
  /**
   * Accessor method for the color of the frog.
   * A live frog is green and a dead frog is red.
   * @return The Color of the frog
   */
  public abstract Color getColor();
  
  /**
   * Requests that the frog be translated the position by the given vector (Point).   
   * Live frogs move by the given amount.   Dead frogs do not move.
   * @param delta The amount to move the frog by.
   * @return The resultant position of the frog
   */
  public abstract Point moveBy(Point delta);
  
  /**
   * The hits the frog.   
   * A live frog will die when it gets hit.   
   * A dead frog stays dead when gets hit. 
   * @return The frog itself is returned.
   */
  public abstract IFrog getHit();
}
