package frog;
import junit.framework.TestCase;
import java.awt.*;

/**
 * A JUnit test case class for BetterFrog.
 */
public class Test_BetterFrog extends TestCase {
  
  /**
   * A test method for the color of the frog.
   */
  public void testColor() {
    IFrog f = new BetterFrog();
    assertEquals("Wrong initial color!", Color.GREEN, f.getColor());
    assertEquals("Wrong color after being hit!", Color.RED, f.getHit().getColor());
    assertEquals("Wrong color after being hit again!", Color.RED, f.getHit().getColor());
  }

  /**
   * A test method for the position of the frog.
   */
  public void testPos() {
    IFrog f = new BetterFrog();
    assertEquals("Wrong initial position!", new Point(0,0), f.getPos());
    assertEquals("Wrong position after being moved!", new Point(2,3), f.moveBy(new Point(2,3)));
    assertEquals("Wrong position!", new Point(2,3), f.getPos());
    assertEquals("Wrong position after being moved!", new Point(7,-4), f.moveBy(new Point(5,-7)));
    assertEquals("Wrong position!", new Point(7,-4), f.getPos());
    assertEquals("Wrong position after being hit!",  new Point(7,-4), f.getHit().getPos());
    assertEquals("Wrong position after being moved!", new Point(7,-4), f.moveBy(new Point(6,1)));
    assertEquals("Wrong position!", new Point(7,-4), f.getPos());
    assertEquals("Wrong position after being hit!",  new Point(7,-4), f.getHit().getPos());
    assertEquals("Wrong position after being moved!", new Point(7,-4), f.moveBy(new Point(-13,-8)));
    assertEquals("Wrong position!", new Point(7,-4), f.getPos());

  }
  
}
