package listFW.test;
import junit.framework.TestCase;
import listFW.*;
import listFW.visitor.*;
import listFW.factory.*;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_CountAll extends TestCase {
  public static final IList MT = InnerCompListFact.Singleton.makeEmptyList();
  
  public static final IListAlgo Algo = CountAll.Singleton;
  
  public void test_emptyCase() {
    assertEquals("Count empty list: ", 0, ((Integer)MT.execute(Algo, null)).intValue());
  }
  
  public void test_nonEmptyCase() {
    IList mt2 = InnerCompListFact.Singleton.makeNEList(MT, MT); // (())
    assertEquals("Count "+mt2+" list: ", 0, ((Integer)mt2.execute(Algo, null)).intValue());
    
    IList mt3 = InnerCompListFact.Singleton.makeNEList(MT, mt2); // ((), (()))
    assertEquals("Count "+mt3+" list: ", 0, ((Integer)mt3.execute(Algo, null)).intValue());
    
    IList L1 = InnerCompListFact.Singleton.makeNEList(null, MT); // (null)
    IList LL1 = InnerCompListFact.Singleton.makeNEList(L1, MT); // ((null))
    assertEquals("Count "+LL1+" list: ", 1, ((Integer)LL1.execute(Algo, null)).intValue());
    
    IList L2 = InnerCompListFact.Singleton.makeNEList(null, L1); // (null, (null))
    IList LL2 = InnerCompListFact.Singleton.makeNEList(L2, MT); // ((null, (null)))
    assertEquals("Count "+LL2+" list: ", 2, ((Integer)LL2.execute(Algo, null)).intValue());
    
    IList LL3 = InnerCompListFact.Singleton.makeNEList(L2, LL1); // ((null, (null)), (null))
    assertEquals("Count "+LL3+" list: ", 3, ((Integer)LL3.execute(Algo, null)).intValue());
  }
}
