package model;
/**
 * STUDENTS:  DO NOT MODIFY THIS CLASS AT ALL!
 * This class represents the "model" where the computation takes place.
 */
public class MyModel {
  /**
   * The adapter through which the model communicates with the view
   */
  private IViewAdapter _viewAdapt;

  /**
   * Internal storage of strings for quotes
   * Do not worry about the syntax used for now.
   */
  private String[] _quotes = {
    "How now brown cow?",
    "I smell a rat!  Or maybe it was just bad code.",
    "I could ha' been a contenda!",
    "Alas poor Yorick!  He looks so different now."
  };
  
  /** 
   * Internal storage of strings for quote sources
   * Do not worry about the syntax used for now.
   */
  private String[] _srcs = {
    "A fertile imagination.",
    "An obscure tome.",
    "The lost and forgotten Shakespeare.",
    "OOP or Overcoming Our Problems"
  };
    
 
  /**
   * Constructor for the model
   * @param viewAdapt  The IViewAdapter the model will communicate to the view through
   */
  public MyModel(IViewAdapter viewAdapt) {
    _viewAdapt = viewAdapt;
  }
 
  /**
   * Internal utility function to randomly pick a string from an array of strings
   * Do not worry about the syntax used for now
   * @param strs An array of strings to pick from
   * @return The randomly chosen string from the given array
   */
  private String pickString(String[] strs) {
    return strs[(int)(strs.length*Math.random())];
  }
  
  /**
   * Returns a random quote string attributed to the given name
   * Also tells the view adapter to display the source of the quote.
   * @param name The name of the person to quote
   * @return A string saying that the given name said a random quote.
   */
  public String getQuoteFrom(String name) {
    _viewAdapt.display("Source: "+pickString(_srcs));
    return name+ " said: \"" + pickString(_quotes)+"\"";
  }
  
}