package view;

import javax.swing.*;  // to use JFrame.
import java.awt.event.*;

/**
 * Minimal reusable code to create a JFrame with a title and a window event
 * listener to call on System.exit() and force termination of the main
 * application that creates this JFrame.
 * @author D.X. Nguyen
 */
public abstract class AFrame extends JFrame {
  
  /**
   * Constructor for the frame.
   * @param title The title for the frame.
   * @param wl The window listener that is called when the frame is closed.
   */
  public AFrame(String title, WindowListener wl) {
    // Always call the superclass's constructor:
    super(title);
    
    addWindowListener(wl);
    
    /**
     * Subclasses are to do whatever is necessary to initialize the frame.
     * CAVEAT: At run-time, when a concrete descendant class of AFrame is
     * created, only the (concrete) initialize() method of this descendant
     * class is called.
     */
    initialize();
  }
  
  /**
   * Relegates to subclasses the responsibility to initialize the system to
   * a well-defined state.
   */
  protected abstract void initialize();
}