package view;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * STUDENTS:  ADD CODE AT THE SPECIFIED LOCATIONS BELOW
 * The class represents the "view" that takes input from the human user and 
 * displays the results of them model's computation based on those inputs. 
 */
public class MyView extends AFrame{
  /**
   * The adapter through which the view will communicate to the model
   */
  private IModelAdapter _modelAdapt;
  
  /**
   * A JLabel that is used to display strings
   * Why can't this be a local variable inside of initialize()?
   */
  private JLabel _lbl;
  private JButton _btn; 
  
  /**
   * Constructor for MyView.
   * @param title The title of the frame
   * @param modelAdapt The adapter through which this view will talk to its model
   */
  public MyView(String title, WindowListener wl, IModelAdapter modelAdapt) {
    super(title, wl);
    _modelAdapt = modelAdapt;
  }
  
  /**
   * Initializes the GUI.  Called from the superclass AFrame's constructor
   * STUDENTS: ADD CODE TO THIS METHOD
   */
  protected void initialize() {  
    setSize(400, 200);
    setLocationRelativeTo(null);
    
    //STUDENTS: YOU MAY ADD MODIFIERS TO THE FOLLOWING LOCAL DEFINTIONS 
    // AS NECESSARY.
    JPanel topPnl = new JPanel();
    JTextField tf = new JTextField("name?");
    JTextArea ta = new JTextArea("Words of wisdom?...");
    
    _lbl = new JLabel("The last word....");
    _btn = new JButton("Click Me!");
    
    Container cp = getContentPane();
    
    cp.add(topPnl, BorderLayout.NORTH);
    cp.add(ta, BorderLayout.CENTER);
    cp.add(_lbl, BorderLayout.SOUTH);
    
    topPnl.add(_btn);
    topPnl.add(tf);
    
    // Add an ActionListener to btn that calls _modelAdapt's one method 
    // using the text field's text as its input.
    // The return value should be used to set the text area's text.
    // Only a single Java statement is required.
    // Any method declared should have only a single line of code.
    // STUDENT CODE STARTS HERE:

    ?????
    
    // END OF STUDENT CODE  
  }
  
  /**
   * Sets the text of the label at the bottom of the screen (i.e. "SOUTH")
   * @param text The text for the label
   */
  public void setBottomLabel(String text) {
    _lbl.setText(text);
  }
}