package lrs.test;
import lrs.*;
import lrs.visitor.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class for SelectionSortLRS.
 */
public class Test_SelectionSortLRS extends TestCase {
  
  private static final IAlgo Algo = SelectionSortLRS.Singleton;
    
  public void test_empty() {
    LRStruct lrs = new LRStruct();
    assertEquals("Incorrect sorting of empty LRStruct!", "()", lrs.execute(Algo, null).toString());
  }

  public void test_one_element() {
    LRStruct lrs = new LRStruct();
    lrs.insertFront(new Integer(3));
    assertEquals("Incorrect sorting of (3)!", "(3)", lrs.execute(Algo, null).toString());
  }

  public void test_two_elements() {
    LRStruct lrs = new LRStruct();
    lrs.insertFront(new Integer(3));
    lrs.insertFront(new Integer(5));
    assertEquals("Incorrect sorting of (5 3)!", "(3 5)", lrs.execute(Algo, null).toString());
    lrs = new LRStruct();
    lrs.insertFront(new Integer(5));
    lrs.insertFront(new Integer(3));
    assertEquals("Incorrect sorting of (3 5)!", "(3 5)", lrs.execute(Algo, null).toString());
  }
  
  public void test_three_elements() {
    LRStruct lrs = new LRStruct();
    lrs.insertFront(new Integer(0));
    lrs.insertFront(new Integer(-2));
    lrs.insertFront(new Integer(4));
    assertEquals("Incorrect sorting of (4 -2 0)!", "(-2 0 4)", lrs.execute(Algo, null).toString());
    lrs = new LRStruct();
    lrs.insertFront(new Integer(-2));
    lrs.insertFront(new Integer(0));
    lrs.insertFront(new Integer(4));
    assertEquals("Incorrect sorting of (-2 0 4)!", "(-2 0 4)", lrs.execute(Algo, null).toString());
    lrs = new LRStruct();
    lrs.insertFront(new Integer(4));
    lrs.insertFront(new Integer(0));
    lrs.insertFront(new Integer(-2));
    assertEquals("Incorrect sorting of (4 0 -2)!", "(-2 0 4)", lrs.execute(Algo, null).toString());
  }
   
}
