package lrs.visitor;

import lrs.*;

public class InsertInOrderLRS implements IAlgo {

  public static final InsertInOrderLRS Singleton 
                                  = new InsertInOrderLRS();

  private InsertInOrderLRS() {
  }

  /**
  * Simply inserts the given parameter n at the front.
  * @param host an empty LRStruct.
  * @param n an Integer to be inserted in order into host.
  * @return LRStruct
  */
  public Object emptyCase(LRStruct host, Object n) {
    return host.insertFront(n);
  }

  /**
  * Based on the comparison between first and n,
  * inserts at the front or recurs!
  * @param host a non-empty LRStruct.
  * @param n an Integer to be inserted in order into host.
  * @return LRStruct
  */
  public Object nonEmptyCase(LRStruct host, Object n) {
    int n_val = ((Integer)n).intValue();
    int f_val = ((Integer)host.getFirst()).intValue();
    if (n_val < f_val) {
      return host.insertFront(n);
    }
    else {
      return host.getRest().execute(this, n);
    }
  }
}

