package view;

import java.awt.*;       // to use Container.
import java.awt.event.*; // to use WindowAdpater and WindowEvent.
import javax.swing.*;    // to use JFrame.

/**
 * A subclass of AFrame containing two JButtons that do nothing.
 * @author D.X. Nguyen
 */
public class Frame1 extends AFrame {

    public Frame1(String title) {
        super(title);
    }

    /**
     * Adds two JButton to the frame.
     * To add a GUI component to a JFrame, one must
     * first get the "content pane", then
     * set the appropriate "layout manager" for the content pane, then
     * add the desire component to content frame.
     * The installed layout manager then automatically arrange the installed
     * GUI component.  For example, the FlowLayout manager will arrange the
     * components from left to right and top to bottom.
     * The use of a separate object to perform distinct layout "strategies" is
     * called the Strategy Pattern.
     */
    protected void initialize() {
        Container cp = getContentPane();
        cp.setLayout(new FlowLayout());
        JButton jb1 = new JButton("Button 1");
        JButton jb2 = new JButton("Button 2");
        cp.add(jb1);
        cp.add(jb2);
        pack();  // Resize to fit snuggly all the components inside this JFrame.
    }
}