package rac;
import lrs.*;

public class LRSStackFactory extends ALRSRACFactory {
    /**
     * Create a ``last-in, first-out'' (LIFO) container.
     */
    public IRAContainer makeRAC() {
        return new LRSRAContainer(new IAlgo() {
            public Object emptyCase(LRStruct host, Object input) {
                return host.insertFront(input);
            }
            
            public Object nonEmptyCase(LRStruct host, Object input) {
                return host.insertFront(input);
            }
        });
    }
    
}