package brs.test;

import junit.framework.TestCase;

import junit.framework.TestCase;
import brs.*;
import brs.visitor.*;

public class Test_CountGreater extends TestCase {
    
    public void test_emptyCase() {
        Integer n = (Integer)new BiTree().execute(CountGreaterThan.Singleton, new Integer(20));
        assertEquals("Empty Tree Node Count...", 0, n.intValue());
    }

    /**
     */
    public void test_nonEmptyCase() {
        BiTree tree = new BiTree();
        Integer key = new Integer(20);
        IVisitor insert = new BSTInserter();
        tree.execute(insert, new Integer(70));
        Integer n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " node greater than: " + key);
        System.out.println("" + tree);
        assertEquals("One Node Count...", 1, n.intValue());
        tree.execute(insert, new Integer(100));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Two Nodes Count...", 2, n.intValue());
        tree.execute(insert, new Integer(50));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Three Nodes Count...", 3, n.intValue());
        tree.execute(insert, new Integer(0));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Four Nodes Count...", 3, n.intValue());
        tree.execute(insert, new Integer(75));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Five Nodes Count...", 4, n.intValue());
        tree.execute(insert, new Integer(20));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Six Nodes Count...", 4, n.intValue());
        tree.execute(insert, new Integer(10));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Seven Nodes Count...", 4, n.intValue());
        tree.execute(insert, new Integer(30));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Eight Nodes Count...", 5, n.intValue());
        tree.execute(insert, new Integer(80));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Nine Nodes Count...", 6, n.intValue());
        tree.execute(insert, new Integer(200));
        n = (Integer)tree.execute(CountGreaterThan.Singleton, key);
        System.out.println(n + " nodes greater than: " + key);
        System.out.println("" + tree);
        assertEquals("Ten Nodes Count...", 7, n.intValue());
    }
    
}
