
package brs.visitor;

import brs.*;

/**
 * Returns the subtree of the host with the max value in the root if the tree
 * is not empty, otherwise returns the host itself, assuming the tree satisfies
 * the BST property.
 * @author DXN
 */
public class MaxTreeFinder implements IVisitor {
    public static final MaxTreeFinder Singleton = new MaxTreeFinder ();

    private MaxTreeFinder ()  {
    }

    /**
    * The host tree is empty: the tree containing the max is the host itself.
    * @param host satisfies the binary search tree property.
    * @param nu == null, not used.
    * @return BiTree the empty host itself.
    */
    public Object emptyCase(BiTree host, Object nu) {
        return host;
    }

    /**
    * Asks the right subtree of the host to find the max via an annomymous
    * helper, passing to it the host as a parameter.
    * @param host satisfies the binary search tree property.
    * @param nu == null, not used.
    * @return BiTree the subtree with maximum root.
    */
    public Object nonEmptyCase (BiTree host, Object nu)  {
        return host.getRightSubTree().execute (new IVisitor () {
            /**
             * The BST parent of an empty right subtree contains the max at the
             * root.
             * @param hp a Bitree, the parent of h.
             */
            public Object emptyCase (BiTree h, Object hp) {
               return hp;
            }

            /**
             * Keep going to the right looking for the max.
             * @param hp a Bitree, the parent of h.
             */
            public Object nonEmptyCase (BiTree h, Object hp) {
               return h.getRightSubTree ().execute (this, h);
            }
        }, host);
    }
}

