package Sorter;
import java.awt.Color;
import javax.swing.JLabel;

/**
 * @dependency Sorter.SorterColor uses
 */
public class GraphicSorter extends ASorter
{

  /**
	 * The decoree to which all calls are delegated.
	 * @SBGen Variable (,aSorter,,0)
	 */
	protected ASorter aSorter;
  /**
	 * The number of milliseconds that the thread will sleep so that the user can see the color changes.
	 *
	 */
	private int waitTime = 500;
  /**
	 * A status label upon which the "split" or "join" is flashed during the wait time to indicate that the respective operation is taking place.
	 */
	private JLabel statusLabel;

  /**
	 * Constructor for this class.
	 * @param aSorter The decoree.
	 * @param statusLabel The JLabel to send status messages to.
	 * @param waitTime The number of milliseconds to pause (sleep).
	 */
	public GraphicSorter(ASorter aSorter, JLabel statusLabel, int waitTime)
  {
   			super(null);
	 this.aSorter = aSorter;
      this.statusLabel = statusLabel;
      this.waitTime = waitTime;

  }



	/**
	 * Delegates to the decoree, then recursively recolors the split sections and pauses.
	 * @param A The array whose sub-array is to be sorted
	 * @param lo The low index of the sub-array
	 * @param hi The high index of the sub-array.
	 * @return the split index.
	 */
	protected int split(Object[] A, int lo, int hi)
  {
    setLabel("Split");
    int s =  aSorter.split(A,lo, hi);       // delegation to decoree
    // s > lo

    SorterColor color = (SorterColor) ((IColoredObject)A[s]).getColor();

    for(int i=lo; i<s;i++)
    {
       ((IColoredObject) A[i]).setColor(color.getLoSplit());
    }

    for(int i=s;i<=hi;i++)
    {
       ((IColoredObject) A[i]).setColor(color.getHiSplit());
    }

    setLabel("Split: Done");
    pause();
    resetLabel();
    return s;
  }

	/**
	 * Delegates to the decoree, then recursively recolors the joined sections and pauses.
	 * @param A The array with the adjacent subarrays to be joined.
	 * @param lo The low index of the lower sub-array
	 * @param s The split index between the sub-arrays
	 * @param hi The high index of the upper sub-array.
	 */
	protected void join(Object[] A, int lo, int s, int hi)
  {
      // lo < hi
      setLabel("Join");
      SorterColor loColor =  (SorterColor)(((IColoredObject) A[lo]).getColor());
      SorterColor hiColor =  (SorterColor)(((IColoredObject) A[hi]).getColor());

      aSorter.join(A,lo,s,hi);        // delegation to decoree

//      SorterColor loColor =  (SorterColor)(((IColoredObject) A[lo]).getColor());
//      SorterColor hiColor =  (SorterColor)(((IColoredObject) A[hi]).getColor());

      SorterColor color = loColor.join(hiColor);

      for(int i=lo;i<=hi;i++)
      {
         ((IColoredObject) A[i]).setColor(color);
      }

      setLabel("Join: Done");
      pause();
      resetLabel();
  }



  /**
	 * Accessor method for the status label.
	 *
	 * @param s String to set as the label's text
	 */
	protected void setLabel(String s)

  {

        statusLabel.setText(s);

  }


  /**
	 * Clears the status label.
	 */
	protected void resetLabel()

  {

        statusLabel.setText("");

  }



  /**
	 * Pauses (sleeps) the thread for waitTime milliseconds.
	 */
	protected void pause()

  {

    try

    {
        Thread.sleep(waitTime);
    }
    catch(Exception e){}
  }

	/**
	 * Accessor method for aOrder.
	 * @param aOrder
	 */
	public void setOrder(AOrder aOrder)
	{
		aSorter.setOrder(aOrder);
	}
}