package Sorter;

/**
 * A concrete sorter that uses the Sink Sort technique.
 */
public class SinkSorter extends ASorter
{
  /**
   * The constructor for this class.
   * @param iCompareOp The comparison strategy to use in the sorting.
   */
  public SinkSorter(AOrder iCompareOp)
  {
    super(iCompareOp);
  }
  /**
   * Splits A[lo:hi] into A[lo:s-1] and A[s:hi] where s is the returned value of this function.
   * This simply splits off the element at index lo.
   * @param A the array A[lo:hi] to be sorted.
   * @param lo the low index of A.
   * @param hi the high index of A.
   * @return lo+1 always.
   */
  protected int split(Object[] A, int lo, int hi)
  {
    return (lo+1);
  }
  
  /**
   * Joins sorted A[lo:s-1] and sorted A[s:hi] into A[lo:hi].   (s = lo+1)
   * The method performs a bubble (sink) of A[lo] from lo towards hi
   * @param A A[lo:s-1] and A[s:hi] are sorted.
   * @param lo the low index of A.
   * @param s
   * @param hi the high index of A.
   */
  protected void join(Object[] A, int lo, int s, int hi)
  {
    //TODO

    
    
      
  }
}