package sorter;

/**
 * Problem 1.a:   Write your analysis and outline your proposed solution here:
 * ---------------------------------------------------------------------------
 * Design Pattern(s) used:
 * 
 * The State design pattern will be used to represent the two states of the sorter.
 * There will be one state for bubbling to lo and one for bubbling to hi.  The states 
 * cause the state change to the other state.
 * 
 * 
 * (Possible) utility of BubbleSorter code:
 * 
 * The BubbleSorter's split method will be used essentially unchanged for the 
 * bubble to lo state.   Everything in the code will be reversed to use it in the 
 * bubble to hi state.
 *
 * 
 */


public class ShakerSorter extends ASorter
{
  //STUDENT TO ADD ANY NECESSARY FIELDS AND NESTED OR INNER CLASSES.
  
  private interface ISortState{
    public int split(Object[] A, int lo, int hi);
  }
  
  private ISortState bubbleLo = new ISortState() {
    public int split(Object[] A, int lo, int hi) {
      for(int j = hi; lo < j; j--) {
        if (aOrder.lt(A[j],A[j-1])) {  // Check if A[j] < A[j-1]
          Object temp = A[j];        // Swap the the neighboring values
          A[j] = A[j-1];
          A[j-1] = temp;
        }
      }
      state = bubbleHi;
      return lo + 1;    
    }
  };
  

  private ISortState bubbleHi = new ISortState() {
    public int split(Object[] A, int lo, int hi) {
      for(int j = lo; j < hi; j++) {
        if (aOrder.lt(A[j+1],A[j])) {  // Check if A[j+1] < A[j]
          Object temp = A[j];        // Swap the the neighboring values
          A[j] = A[j+1];
          A[j+1] = temp;
        }
      }
      state = bubbleLo;
      return hi;    
    }
  };
  
  private ISortState state = bubbleLo;
  
  /**
   * @param iCompareOp
   */
  public ShakerSorter(AOrder iCompareOp)
  {
    super(iCompareOp);
  }
  
  /**
   * Splits A[lo:hi] into A[lo:s-1] and A[s:hi] where s is the returned value of this function.
   * @param A the array A[lo:hi] to be sorted.
   * @param lo the low index of A.
   * @param hi the high index of A.
   * @return
   */
  protected int split(Object[] A, int lo, int hi)
  {
    //STUDENT TO COMPLETE
//    return hi;  // STUB CODE!  REPLACE WITH STUDENT CODE.
    return state.split(A, lo, hi);
  }
  
  /**
   * Joins sorted A[lo:s-1] and sorted A[s:hi] into A[lo:hi].
   * @param A A[lo:s-1] and A[s:hi] are sorted.
   * @param lo the low index of A.
   * @param s
   * @param hi the high index of A.
   */
  protected void join(Object[] A, int lo, int s, int hi)
  {
    //STUDENT TO COMPLETE
  }
}

