package array;

public class ArrayUtils {
    public static final ArrayUtils Singleton = new ArrayUtils();
    private ArrayUtils() {
    }
    
    /**
     * Counts the number of elements in a 2-dimensional array.
     * @param m != null
     * @return the maximum number of elements that can be stored in m.
     */
    public int countElements(Object[][] m) {
      // STUDENT TO COMPLETE
        int result = 0;
        for (int i = 0; i < m.length; i++) {
            result += m[i].length;
        }
        return result;
    }
    
    /**
     * Copy elements from a 1-dimensional array to another 1-dimensional array.
     * @param src != null, the source array
     * @param srcLo the low index of the subrange in the src array; 
     * 0 <= srcLo <= src.length - 1 must be true, otherwise, 
     * throws an IllegalArgumentException.
     * @param maxElts >=0, the maximum number of elements in the src array to 
     * be copied to the dest array at dstLo. The actual number of elements 
     * copied is the minimum of maxElts, the number of elements remaining 
     * in src starting at srcLo, and the number of elements remaining in dest 
     * starting at dstLo.  If maxElts < 0 do nothing.
     * @param dest !=null, the destination array.
     * @param dstLo the low index of the subrange in the dest array.
     * 0 <= dstLo <= dst.length - 1 must be true, otherwise, 
     * throws an IllegalArgumentException.
     * @exception IllegalArgumentException whenever any of the conditions of srcLo 
     * and dstLo as stated in the above are violated.
     */
    public void copyArray(Object[] src, int srcLo, int maxElts, 
                          Object[] dest, int dstLo) {
      //STUDENT TO COMPLETE
     
        if ((srcLo < 0) || (srcLo > src.length - 1) 
                || (dstLo < 0) || (dstLo > dest.length - 1)) {
            throw new IllegalArgumentException("Array indices not in range!");
            //throw new IllegalStateException("Array indices not in range!");
        }
        int hi = Math.min(maxElts,Math.min(src.length - srcLo, dest.length - dstLo));
        for (int i = 0; i < hi; i++) {
            dest[dstLo + i] = src[srcLo + i];
        }
    }
    
    /**
     * Converts a 2-dimensional array m to a 1-dimensional array whose size is
     * the number of elements in the input matrix m.
     * @param m != null.
     * @return a 1-dimensional array that is the concatenation of all the row arrays
     * in the matrix from the lowest row index to the highest row index.
     */
    public Object[] matrix2array(Object[][] m) {
      // STUDENT TO COMPLETE
        int size = countElements(m);
        Object[] result = new Object[size];
        int offset = 0;
        for (int r = 0; r < m.length; r++) {
            if (m[r].length > 0) {
                copyArray(m[r], 0, m[r].length, result, offset);
                offset += m[r].length;
            }
        }
        return result; 
    }
}