/**
 *  Prob. 3.c  Extra credit:  Write your answer below:
 * ---------------------------------------------------------------
 * 
 * The RACTraverse algorithm already can handle creating a result that 
 * ordered by value.   All you need to do is to supply a priority queue
 * RAC (via PQComparatorRACFactory) with the appropriate Comparator
 * or using built-in Comparator of Comparables.    The Comparator will 
 * determine the ordering by value.   
 * 
 * No additional code needs to be written!
 * 
 * Below, we test using the internal Comparator of PQComparatorRACFactory,
 * so the BiTree is assumed to hold Comparables and they will come out in 
 * descending order.
 * 
 */
package brs.visitor.test;
import brs.*;
import brs.visitor.*;
import rac.*;
import listFW.*;
import listFW.factory.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_RACTraverse_Extra extends TestCase {
  
  // STUDENT TO COMPLETE ALL NECESSARY TEST CASES
  // REMEMBER: ALL TEST METHOD NAMES MUST BEGIN WITH "test"
  
  IVisitor algo = RACTraverse.Singleton;
  IRACFactory pqFac = new PQComparatorRACFactory();
  
  
  public void test_emptyBRS() {
    BiTree brs = new BiTree();
    
    IRAContainer rac = pqFac.makeRAC();
    
    assertEquals("Empty BRS + priority queue", "()", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());    
  }
  
  
  public void test_LeafBRS() {
    BiTree brs = new BiTree();    
    brs.insertRoot("a");
    
    IRAContainer rac = pqFac.makeRAC();    
    assertEquals("1 elt BRS + priority queue", "(a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());  
  }
  
  
  public void test_2eltBRS() {
    BiTree brs = new BiTree();   
    brs.insertRoot("a");  
    brs.getLeftSubTree().insertRoot("b");
    
    IRAContainer rac = pqFac.makeRAC();  
    assertEquals("2 elt BRS + priority queue", "(b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
    
    brs = new BiTree();    
    brs.insertRoot("a");
    brs.getRightSubTree().insertRoot("b");
    
    rac = pqFac.makeRAC();   
    assertEquals("2 elt BRS + priority queue", "(b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
    brs = new BiTree();    
    brs.insertRoot("b");
    brs.getRightSubTree().insertRoot("a");
    
    rac = pqFac.makeRAC();   
    assertEquals("2 elt BRS + priority queue", "(b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
  }
  
  
  public void test_3eltBRS() {
    BiTree brs = new BiTree();   
    brs.insertRoot("a");  
    brs.getLeftSubTree().insertRoot("b");
    brs.getRightSubTree().insertRoot("c");
    
    IRAContainer rac = pqFac.makeRAC();  
    assertEquals("3 elt BRS + priority queue", "(c, b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
    brs = new BiTree();   
    brs.insertRoot("b");  
    brs.getLeftSubTree().insertRoot("c");
    brs.getRightSubTree().insertRoot("a");
    
    rac = pqFac.makeRAC(); 
    assertEquals("3 elt BRS + priority queue", "(c, b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
    brs = new BiTree();   
    brs.insertRoot("c");  
    brs.getLeftSubTree().insertRoot("a");
    brs.getRightSubTree().insertRoot("b");
    
    rac = pqFac.makeRAC(); 
    assertEquals("3 elt BRS + priority queue", "(c, b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
  } 
  public void test_6eltBRS() {
    BiTree brs = new BiTree();   
    brs.insertRoot("a");  
    brs.getLeftSubTree().insertRoot("b");
    brs.getRightSubTree().insertRoot("c");
    brs.getLeftSubTree().getLeftSubTree().insertRoot("d");
    brs.getLeftSubTree().getRightSubTree().insertRoot("e");
    brs.getRightSubTree().getLeftSubTree().insertRoot("f");
    brs.getRightSubTree().getRightSubTree().insertRoot("g");
    
    IRAContainer rac = pqFac.makeRAC();  
    assertEquals("6 elt BRS + priority queue", "(g, f, e, d, c, b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
  }
}
